"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAddress = exports.getAddressLowerCase = exports.BEACON_CHAIN_DEPOSIT_ADDRESS = exports.WETH9 = exports.constructSameAddressMap = exports.MULTICALL2_ADDRESS = exports.V3_MIGRATOR_ADDRESS = exports.NONFUNGIBLE_POSITION_MANAGER_ADDRESS = exports.TICK_LENS_ADDRESS = exports.ARB_GASINFO_ADDRESS = exports.OVM_GASPRICE_ADDRESS = exports.STATE_VIEW_ADDRESSES = exports.SWAP_ROUTER_02_ADDRESSES = exports.UNISWAP_MULTICALL_ADDRESSES = exports.MIXED_ROUTE_QUOTER_V2_ADDRESSES = exports.MIXED_ROUTE_QUOTER_V1_ADDRESSES = exports.PROTOCOL_V4_QUOTER_ADDRESSES = exports.NEW_QUOTER_V2_ADDRESSES = exports.QUOTER_V2_ADDRESSES = exports.V3_CORE_FACTORY_ADDRESSES = exports.BNB_V3_MIGRATOR_ADDRESS = exports.BNB_SWAP_ROUTER_02_ADDRESS = exports.BNB_NONFUNGIBLE_POSITION_MANAGER_ADDRESS = exports.BNB_TICK_LENS_ADDRESS = void 0;
const sdk_core_1 = require("@uniswap/sdk-core");
const v3_sdk_1 = require("@uniswap/v3-sdk");
const router_sdk_1 = require("@uniswap/router-sdk");
const chains_1 = require("./chains");
exports.BNB_TICK_LENS_ADDRESS = sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BNB].tickLensAddress;
exports.BNB_NONFUNGIBLE_POSITION_MANAGER_ADDRESS = sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BNB].nonfungiblePositionManagerAddress;
exports.BNB_SWAP_ROUTER_02_ADDRESS = sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BNB].swapRouter02Address;
exports.BNB_V3_MIGRATOR_ADDRESS = sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BNB].v3MigratorAddress;
exports.V3_CORE_FACTORY_ADDRESSES = Object.assign(Object.assign({}, constructSameAddressMap(v3_sdk_1.FACTORY_ADDRESS)), { [sdk_core_1.ChainId.CELO]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.CELO].v3CoreFactoryAddress, [sdk_core_1.ChainId.CELO_ALFAJORES]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.CELO_ALFAJORES].v3CoreFactoryAddress, [sdk_core_1.ChainId.OPTIMISM_GOERLI]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.OPTIMISM_GOERLI].v3CoreFactoryAddress, [sdk_core_1.ChainId.OPTIMISM_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.OPTIMISM_SEPOLIA].v3CoreFactoryAddress, [sdk_core_1.ChainId.SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SEPOLIA].v3CoreFactoryAddress, [sdk_core_1.ChainId.ARBITRUM_GOERLI]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ARBITRUM_GOERLI].v3CoreFactoryAddress, [sdk_core_1.ChainId.ARBITRUM_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ARBITRUM_SEPOLIA].v3CoreFactoryAddress, [sdk_core_1.ChainId.BNB]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BNB].v3CoreFactoryAddress, [sdk_core_1.ChainId.AVALANCHE]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.AVALANCHE].v3CoreFactoryAddress, [sdk_core_1.ChainId.BASE_GOERLI]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BASE_GOERLI].v3CoreFactoryAddress, [sdk_core_1.ChainId.BASE]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BASE].v3CoreFactoryAddress, [sdk_core_1.ChainId.BLAST]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BLAST].v3CoreFactoryAddress, [sdk_core_1.ChainId.ZORA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ZORA].v3CoreFactoryAddress, [sdk_core_1.ChainId.ZKSYNC]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ZKSYNC].v3CoreFactoryAddress, [sdk_core_1.ChainId.WORLDCHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.WORLDCHAIN].v3CoreFactoryAddress, [sdk_core_1.ChainId.UNICHAIN_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN_SEPOLIA].v3CoreFactoryAddress, [sdk_core_1.ChainId.MONAD_TESTNET]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.MONAD_TESTNET].v3CoreFactoryAddress, [sdk_core_1.ChainId.BASE_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BASE_SEPOLIA].v3CoreFactoryAddress, 
    // TODO: Gnosis + Moonbeam contracts to be deployed
    [sdk_core_1.ChainId.UNICHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN].v3CoreFactoryAddress, [sdk_core_1.ChainId.SONEIUM]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SONEIUM].v3CoreFactoryAddress });
exports.QUOTER_V2_ADDRESSES = Object.assign(Object.assign({}, constructSameAddressMap('0x61fFE014bA17989E743c5F6cB21bF9697530B21e')), { [sdk_core_1.ChainId.CELO]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.CELO].quoterAddress, [sdk_core_1.ChainId.CELO_ALFAJORES]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.CELO_ALFAJORES].quoterAddress, [sdk_core_1.ChainId.OPTIMISM_GOERLI]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.OPTIMISM_GOERLI].quoterAddress, [sdk_core_1.ChainId.OPTIMISM_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.OPTIMISM_SEPOLIA].quoterAddress, [sdk_core_1.ChainId.SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SEPOLIA].quoterAddress, [sdk_core_1.ChainId.ARBITRUM_GOERLI]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ARBITRUM_GOERLI].quoterAddress, [sdk_core_1.ChainId.ARBITRUM_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ARBITRUM_SEPOLIA].quoterAddress, [sdk_core_1.ChainId.BNB]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BNB].quoterAddress, [sdk_core_1.ChainId.AVALANCHE]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.AVALANCHE].quoterAddress, [sdk_core_1.ChainId.BASE_GOERLI]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BASE_GOERLI].quoterAddress, [sdk_core_1.ChainId.BASE]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BASE].quoterAddress, [sdk_core_1.ChainId.BLAST]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BLAST].quoterAddress, [sdk_core_1.ChainId.ZORA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ZORA].quoterAddress, [sdk_core_1.ChainId.ZKSYNC]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ZKSYNC].quoterAddress, [sdk_core_1.ChainId.WORLDCHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.WORLDCHAIN].quoterAddress, [sdk_core_1.ChainId.UNICHAIN_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN_SEPOLIA].quoterAddress, [sdk_core_1.ChainId.MONAD_TESTNET]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.MONAD_TESTNET].quoterAddress, [sdk_core_1.ChainId.BASE_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BASE_SEPOLIA].quoterAddress, 
    // TODO: Gnosis + Moonbeam contracts to be deployed
    [sdk_core_1.ChainId.UNICHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN].quoterAddress, [sdk_core_1.ChainId.SONEIUM]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SONEIUM].quoterAddress });
exports.NEW_QUOTER_V2_ADDRESSES = Object.assign(Object.assign({}, constructSameAddressMap('0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3')), { [sdk_core_1.ChainId.CELO]: '0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3', [sdk_core_1.ChainId.CELO_ALFAJORES]: '0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3', [sdk_core_1.ChainId.OPTIMISM_SEPOLIA]: '0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3', [sdk_core_1.ChainId.SEPOLIA]: '0xf0c802dcb0cf1c4f7b953756b49d940eed190221', [sdk_core_1.ChainId.ARBITRUM_SEPOLIA]: '0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3', [sdk_core_1.ChainId.BNB]: '0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3', [sdk_core_1.ChainId.AVALANCHE]: '0xf0c802dcb0cf1c4f7b953756b49d940eed190221', [sdk_core_1.ChainId.POLYGON_MUMBAI]: '0x60e06b92bC94a665036C26feC5FF2A92E2d04c5f', [sdk_core_1.ChainId.BASE]: '0x222cA98F00eD15B1faE10B61c277703a194cf5d2', [sdk_core_1.ChainId.BLAST]: '0x9D0F15f2cf58655fDDcD1EE6129C547fDaeD01b1', [sdk_core_1.ChainId.ZORA]: '0x9D0F15f2cf58655fDDcD1EE6129C547fDaeD01b1', [sdk_core_1.ChainId.ZKSYNC]: '0x071Bd2063dF031EDd110E27C6F4CDe50A3DeF2d4', [sdk_core_1.ChainId.WORLDCHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.WORLDCHAIN].quoterAddress, [sdk_core_1.ChainId.UNICHAIN_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN_SEPOLIA].quoterAddress, [sdk_core_1.ChainId.MONAD_TESTNET]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.MONAD_TESTNET].quoterAddress, [sdk_core_1.ChainId.BASE_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BASE_SEPOLIA].quoterAddress, [sdk_core_1.ChainId.UNICHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN].quoterAddress, [sdk_core_1.ChainId.SONEIUM]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SONEIUM].quoterAddress });
exports.PROTOCOL_V4_QUOTER_ADDRESSES = Object.assign(Object.assign({}, constructSameAddressMap('0xf3a39c86dbd13c45365e57fb90fe413371f65af8')), { [sdk_core_1.ChainId.SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SEPOLIA].v4QuoterAddress, [sdk_core_1.ChainId.ARBITRUM_ONE]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ARBITRUM_ONE].v4QuoterAddress, [sdk_core_1.ChainId.BASE]: '0xe1a6c5803e3c44368b171bd680c7d32dfc92ca47', [sdk_core_1.ChainId.POLYGON]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.POLYGON].v4QuoterAddress, [sdk_core_1.ChainId.BNB]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BNB].v4QuoterAddress, [sdk_core_1.ChainId.AVALANCHE]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.AVALANCHE].v4QuoterAddress, [sdk_core_1.ChainId.OPTIMISM]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.OPTIMISM].v4QuoterAddress, [sdk_core_1.ChainId.WORLDCHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.WORLDCHAIN].v4QuoterAddress, [sdk_core_1.ChainId.ZORA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ZORA].v4QuoterAddress, [sdk_core_1.ChainId.UNICHAIN_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN_SEPOLIA].v4QuoterAddress, [sdk_core_1.ChainId.UNICHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN].v4QuoterAddress, [sdk_core_1.ChainId.BLAST]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BLAST].v4QuoterAddress, [sdk_core_1.ChainId.MAINNET]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.MAINNET].v4QuoterAddress, [sdk_core_1.ChainId.SONEIUM]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SONEIUM].v4QuoterAddress });
exports.MIXED_ROUTE_QUOTER_V1_ADDRESSES = {
    [sdk_core_1.ChainId.MAINNET]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.MAINNET].mixedRouteQuoterV1Address,
    [sdk_core_1.ChainId.GOERLI]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.GOERLI].mixedRouteQuoterV1Address,
    [sdk_core_1.ChainId.BASE]: '0xe544efae946f0008ae9a8d64493efa7886b73776',
    [sdk_core_1.ChainId.UNICHAIN]: '0x48C0648E357639B446C99a6c7316A3eaFEaB35aE',
    [sdk_core_1.ChainId.ARBITRUM_ONE]: '0x003aa18c6E682dB80Cf4aa17261CcbFfd28690CE',
    [sdk_core_1.ChainId.POLYGON]: '0x58ead433EA99708604C4dD7c9b7E80C70976E202',
    [sdk_core_1.ChainId.OPTIMISM]: '0x204faca1764b154221e35c0d20abb3c525710498',
    [sdk_core_1.ChainId.AVALANCHE]: '0x204FAca1764B154221e35c0d20aBb3c525710498',
    [sdk_core_1.ChainId.BNB]: '0x204FAca1764B154221e35c0d20aBb3c525710498',
    [sdk_core_1.ChainId.WORLDCHAIN]: '0x204FAca1764B154221e35c0d20aBb3c525710498',
    [sdk_core_1.ChainId.ZORA]: '0x204FAca1764B154221e35c0d20aBb3c525710498',
    [sdk_core_1.ChainId.SONEIUM]: '0x42c14CE921e85bf14467A82fAf8182546cf7c604',
};
exports.MIXED_ROUTE_QUOTER_V2_ADDRESSES = {
    [sdk_core_1.ChainId.SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SEPOLIA].mixedRouteQuoterV2Address,
    [sdk_core_1.ChainId.MAINNET]: '0xE63C5F5005909E96b5aA9CE10744CCE70eC16CC3',
    [sdk_core_1.ChainId.BASE]: '0x253ee8eb6551b47181b613461c15d699fe4a2e39',
    [sdk_core_1.ChainId.UNICHAIN]: '0x48C0648E357639B446C99a6c7316A3eaFEaB35aE',
    [sdk_core_1.ChainId.ARBITRUM_ONE]: '0x9D0F15f2cf58655fDDcD1EE6129C547fDaeD01b1',
    [sdk_core_1.ChainId.POLYGON]: '0x9d0f15f2cf58655fddcd1ee6129c547fdaed01b1',
    [sdk_core_1.ChainId.OPTIMISM]: '0xf0c802DCb0cF1C4f7B953756b49D940EED190221',
    [sdk_core_1.ChainId.AVALANCHE]: '0x9D0F15f2cf58655fDDcD1EE6129C547fDaeD01b1',
    [sdk_core_1.ChainId.BNB]: '0xf0c802DCb0cF1C4f7B953756b49D940EED190221',
    [sdk_core_1.ChainId.WORLDCHAIN]: '0x9D0F15f2cf58655fDDcD1EE6129C547fDaeD01b1',
    [sdk_core_1.ChainId.ZORA]: '0x5f739c790a48E97eec0efb81bab5D152c0A0ecA0',
    [sdk_core_1.ChainId.SONEIUM]: '0x42c14CE921e85bf14467A82fAf8182546cf7c604',
};
exports.UNISWAP_MULTICALL_ADDRESSES = Object.assign(Object.assign({}, constructSameAddressMap('0x1F98415757620B543A52E61c46B32eB19261F984')), { [sdk_core_1.ChainId.CELO]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.CELO].multicallAddress, [sdk_core_1.ChainId.CELO_ALFAJORES]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.CELO_ALFAJORES].multicallAddress, [sdk_core_1.ChainId.OPTIMISM_GOERLI]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.OPTIMISM_GOERLI].multicallAddress, [sdk_core_1.ChainId.OPTIMISM_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.OPTIMISM_SEPOLIA].multicallAddress, [sdk_core_1.ChainId.SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SEPOLIA].multicallAddress, [sdk_core_1.ChainId.ARBITRUM_GOERLI]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ARBITRUM_GOERLI].multicallAddress, [sdk_core_1.ChainId.ARBITRUM_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ARBITRUM_SEPOLIA].multicallAddress, [sdk_core_1.ChainId.BNB]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BNB].multicallAddress, [sdk_core_1.ChainId.AVALANCHE]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.AVALANCHE].multicallAddress, [sdk_core_1.ChainId.BASE_GOERLI]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BASE_GOERLI].multicallAddress, [sdk_core_1.ChainId.BASE]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BASE].multicallAddress, [sdk_core_1.ChainId.BLAST]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BLAST].multicallAddress, [sdk_core_1.ChainId.ZORA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ZORA].multicallAddress, [sdk_core_1.ChainId.ZKSYNC]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ZKSYNC].multicallAddress, [sdk_core_1.ChainId.WORLDCHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.WORLDCHAIN].multicallAddress, [sdk_core_1.ChainId.UNICHAIN_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN_SEPOLIA].multicallAddress, [sdk_core_1.ChainId.MONAD_TESTNET]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.MONAD_TESTNET].multicallAddress, [sdk_core_1.ChainId.BASE_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BASE_SEPOLIA].multicallAddress, 
    // TODO: Gnosis + Moonbeam contracts to be deployed
    [sdk_core_1.ChainId.UNICHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN].multicallAddress, [sdk_core_1.ChainId.SONEIUM]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SONEIUM].multicallAddress });
const SWAP_ROUTER_02_ADDRESSES = (chainId) => {
    var _a;
    return ((_a = (0, sdk_core_1.SWAP_ROUTER_02_ADDRESSES)(chainId)) !== null && _a !== void 0 ? _a : '0x68b3465833fb72A70ecDF485E0e4C7bD8665Fc45');
};
exports.SWAP_ROUTER_02_ADDRESSES = SWAP_ROUTER_02_ADDRESSES;
exports.STATE_VIEW_ADDRESSES = Object.assign(Object.assign({}, constructSameAddressMap('0x1F98415757620B543A52E61c46B32eB19261F984')), { [sdk_core_1.ChainId.SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SEPOLIA].v4StateView, [sdk_core_1.ChainId.ARBITRUM_ONE]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ARBITRUM_ONE].v4StateView, [sdk_core_1.ChainId.BASE]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BASE].v4StateView, [sdk_core_1.ChainId.POLYGON]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.POLYGON].v4StateView, [sdk_core_1.ChainId.BNB]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BNB].v4StateView, [sdk_core_1.ChainId.OPTIMISM]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.OPTIMISM].v4StateView, [sdk_core_1.ChainId.AVALANCHE]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.AVALANCHE].v4StateView, [sdk_core_1.ChainId.WORLDCHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.WORLDCHAIN].v4StateView, [sdk_core_1.ChainId.ZORA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ZORA].v4StateView, [sdk_core_1.ChainId.UNICHAIN_SEPOLIA]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN_SEPOLIA].v4StateView, [sdk_core_1.ChainId.UNICHAIN]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.UNICHAIN].v4StateView, [sdk_core_1.ChainId.BLAST]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.BLAST].v4StateView, [sdk_core_1.ChainId.MAINNET]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.MAINNET].v4StateView, [sdk_core_1.ChainId.SONEIUM]: sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.SONEIUM].v4StateView });
exports.OVM_GASPRICE_ADDRESS = '0x420000000000000000000000000000000000000F';
exports.ARB_GASINFO_ADDRESS = '0x000000000000000000000000000000000000006C';
exports.TICK_LENS_ADDRESS = sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.ARBITRUM_ONE].tickLensAddress;
exports.NONFUNGIBLE_POSITION_MANAGER_ADDRESS = sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.MAINNET].nonfungiblePositionManagerAddress;
exports.V3_MIGRATOR_ADDRESS = sdk_core_1.CHAIN_TO_ADDRESSES_MAP[sdk_core_1.ChainId.MAINNET].v3MigratorAddress;
exports.MULTICALL2_ADDRESS = '0x5BA1e12693Dc8F9c48aAD8770482f4739bEeD696';
function constructSameAddressMap(address, additionalNetworks = []) {
    return chains_1.NETWORKS_WITH_SAME_UNISWAP_ADDRESSES.concat(additionalNetworks).reduce((memo, chainId) => {
        memo[chainId] = address;
        return memo;
    }, {});
}
exports.constructSameAddressMap = constructSameAddressMap;
exports.WETH9 = {
    [sdk_core_1.ChainId.MAINNET]: sdk_core_1.WETH9[sdk_core_1.ChainId.MAINNET],
    [sdk_core_1.ChainId.GOERLI]: sdk_core_1.WETH9[sdk_core_1.ChainId.GOERLI],
    [sdk_core_1.ChainId.SEPOLIA]: sdk_core_1.WETH9[sdk_core_1.ChainId.SEPOLIA],
    [sdk_core_1.ChainId.OPTIMISM]: sdk_core_1.WETH9[sdk_core_1.ChainId.OPTIMISM],
    [sdk_core_1.ChainId.OPTIMISM_GOERLI]: new sdk_core_1.Token(sdk_core_1.ChainId.OPTIMISM_GOERLI, '0x4200000000000000000000000000000000000006', 18, 'WETH', 'Wrapped Ether'),
    [sdk_core_1.ChainId.OPTIMISM_SEPOLIA]: sdk_core_1.WETH9[sdk_core_1.ChainId.OPTIMISM_SEPOLIA],
    [sdk_core_1.ChainId.ARBITRUM_ONE]: sdk_core_1.WETH9[sdk_core_1.ChainId.ARBITRUM_ONE],
    [sdk_core_1.ChainId.ARBITRUM_GOERLI]: new sdk_core_1.Token(sdk_core_1.ChainId.ARBITRUM_GOERLI, '0xe39Ab88f8A4777030A534146A9Ca3B52bd5D43A3', 18, 'WETH', 'Wrapped Ether'),
    [sdk_core_1.ChainId.ARBITRUM_SEPOLIA]: sdk_core_1.WETH9[sdk_core_1.ChainId.ARBITRUM_SEPOLIA],
    [sdk_core_1.ChainId.BASE_GOERLI]: new sdk_core_1.Token(sdk_core_1.ChainId.BASE_GOERLI, '0x4200000000000000000000000000000000000006', 18, 'WETH', 'Wrapped Ether'),
    [sdk_core_1.ChainId.BASE]: sdk_core_1.WETH9[sdk_core_1.ChainId.BASE],
    [sdk_core_1.ChainId.BLAST]: sdk_core_1.WETH9[sdk_core_1.ChainId.BLAST],
    [sdk_core_1.ChainId.ZORA]: sdk_core_1.WETH9[sdk_core_1.ChainId.ZORA],
    [sdk_core_1.ChainId.ZORA_SEPOLIA]: new sdk_core_1.Token(sdk_core_1.ChainId.ZORA_SEPOLIA, '0x4200000000000000000000000000000000000006', 18, 'WETH', 'Wrapped Ether'),
    [sdk_core_1.ChainId.ZKSYNC]: sdk_core_1.WETH9[sdk_core_1.ChainId.ZKSYNC],
    [sdk_core_1.ChainId.WORLDCHAIN]: sdk_core_1.WETH9[sdk_core_1.ChainId.WORLDCHAIN],
    [sdk_core_1.ChainId.UNICHAIN_SEPOLIA]: sdk_core_1.WETH9[sdk_core_1.ChainId.UNICHAIN_SEPOLIA],
    [sdk_core_1.ChainId.BASE_SEPOLIA]: sdk_core_1.WETH9[sdk_core_1.ChainId.BASE_SEPOLIA],
    [sdk_core_1.ChainId.UNICHAIN]: sdk_core_1.WETH9[sdk_core_1.ChainId.UNICHAIN],
    [sdk_core_1.ChainId.SONEIUM]: sdk_core_1.WETH9[sdk_core_1.ChainId.SONEIUM],
};
exports.BEACON_CHAIN_DEPOSIT_ADDRESS = '0x00000000219ab540356cBB839Cbe05303d7705Fa';
function getAddressLowerCase(currency) {
    if (currency.isToken) {
        return currency.address.toLowerCase();
    }
    else {
        return router_sdk_1.ADDRESS_ZERO;
    }
}
exports.getAddressLowerCase = getAddressLowerCase;
function getAddress(currency) {
    if (currency.isToken) {
        return currency.address;
    }
    else {
        return router_sdk_1.ADDRESS_ZERO;
    }
}
exports.getAddress = getAddress;
//# sourceMappingURL=data:application/json;base64,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